# 🚀 Guía de Despliegue Permanente - Landing Page

## ✨ Método más fácil: Netlify Drop (2 minutos, sin código)

### Paso 1: Preparar archivos
Ya tienes el archivo `landing-mama-emprendedora.zip` descargado con todos los archivos necesarios.

### Paso 2: Ir a Netlify Drop
1. Abre tu navegador
2. Ve a: **https://app.netlify.com/drop**
3. NO necesitas crear cuenta todavía

### Paso 3: Desplegar
1. **Descomprime** el archivo `landing-mama-emprendedora.zip` en tu computadora
2. **Arrastra toda la carpeta** `landing-mama-emprendedora` a la página de Netlify Drop
3. Espera 30 segundos mientras sube los archivos
4. ¡Listo! Netlify te dará una URL permanente como: `https://nombre-aleatorio.netlify.app`

### Paso 4: Personalizar dominio (opcional)
1. Crea una cuenta gratuita en Netlify (con email o GitHub)
2. Reclama el sitio que acabas de subir
3. Ve a "Domain settings" → "Edit site name"
4. Cambia el nombre a algo como: `mama-emprendedora-casa`
5. Tu URL será: `https://mama-emprendedora-casa.netlify.app`

---

## 🎯 Alternativa: Vercel (también muy fácil)

### Paso 1: Crear cuenta
1. Ve a: **https://vercel.com/signup**
2. Regístrate con tu email o GitHub (gratis)

### Paso 2: Desplegar
1. Haz clic en "Add New..." → "Project"
2. Arrastra la carpeta `landing-mama-emprendedora` descomprimida
3. Haz clic en "Deploy"
4. Espera 1 minuto
5. ¡Listo! Tu URL será: `https://nombre-proyecto.vercel.app`

---

## 🌐 Alternativa: GitHub Pages (gratis para siempre)

### Paso 1: Crear cuenta en GitHub
1. Ve a: **https://github.com/signup**
2. Crea tu cuenta gratuita

### Paso 2: Crear repositorio
1. Haz clic en el botón verde "New" (nuevo repositorio)
2. Nombre: `landing-mama-emprendedora`
3. Marca como "Public"
4. Haz clic en "Create repository"

### Paso 3: Subir archivos
1. Haz clic en "uploading an existing file"
2. Arrastra TODOS los archivos de la carpeta descomprimida
3. Escribe un mensaje como "Initial commit"
4. Haz clic en "Commit changes"

### Paso 4: Activar GitHub Pages
1. Ve a "Settings" → "Pages"
2. En "Source" selecciona "main" branch
3. Haz clic en "Save"
4. Espera 2 minutos
5. Tu sitio estará en: `https://tu-usuario.github.io/landing-mama-emprendedora`

---

## 💡 Recomendación

**Te recomiendo Netlify Drop** porque:
- ✅ No necesitas cuenta para empezar
- ✅ Arrastra y suelta, listo
- ✅ URL permanente al instante
- ✅ Puedes reclamar el sitio después
- ✅ SSL/HTTPS gratis incluido
- ✅ Actualizaciones fáciles (solo arrastra de nuevo)

---

## 🔄 Cómo actualizar tu sitio después

### En Netlify:
1. Entra a tu cuenta
2. Ve a tu sitio
3. Arrastra la nueva versión de los archivos
4. ¡Actualizado!

### En Vercel:
1. Entra a tu proyecto
2. Haz clic en "Redeploy"
3. O conecta con GitHub para actualizaciones automáticas

### En GitHub Pages:
1. Ve a tu repositorio
2. Sube los archivos nuevos (reemplazarán los antiguos)
3. Espera 1-2 minutos para que se actualice

---

## 🆘 Solución de problemas

### Las imágenes no se ven
- Asegúrate de subir TODOS los archivos .jpg junto con index.html
- Los archivos deben estar en la misma carpeta

### El sitio se ve sin estilos
- Verifica que subiste el archivo `styles.css`
- Limpia la caché del navegador (Ctrl + F5)

### Los botones no funcionan
- Verifica que subiste el archivo `script.js`
- El link de Hotmart ya está integrado, debería funcionar

---

## 📊 Comparación de servicios

| Servicio | Facilidad | Velocidad | Dominio personalizado | Límites |
|----------|-----------|-----------|----------------------|---------|
| **Netlify** | ⭐⭐⭐⭐⭐ | Muy rápido | Gratis | 100 GB/mes |
| **Vercel** | ⭐⭐⭐⭐ | Muy rápido | Gratis | 100 GB/mes |
| **GitHub Pages** | ⭐⭐⭐ | Rápido | Gratis | 1 GB espacio |

---

## 🎁 Bonus: Dominio personalizado

Si quieres un dominio propio como `www.tuemprendimiento.com`:

1. Compra el dominio en:
   - Namecheap (~$10/año)
   - Google Domains (~$12/año)
   - GoDaddy (~$15/año)

2. Conecta el dominio:
   - En Netlify: Settings → Domain management → Add custom domain
   - En Vercel: Settings → Domains → Add
   - En GitHub Pages: Settings → Pages → Custom domain

3. Sigue las instrucciones para configurar los DNS

---

## ✅ Checklist final

Antes de desplegar, verifica que tienes:
- [ ] Archivo ZIP descargado
- [ ] Carpeta descomprimida
- [ ] Todos los archivos visibles (HTML, CSS, JS, imágenes)
- [ ] Cuenta creada en el servicio elegido (si aplica)
- [ ] Navegador actualizado

---

## 🎯 Resumen ultra rápido

1. Descomprime el ZIP
2. Ve a https://app.netlify.com/drop
3. Arrastra la carpeta
4. ¡Listo! Copia tu URL permanente

**Tiempo total: 2 minutos** ⏱️

---

¿Necesitas ayuda? Todos estos servicios tienen soporte 24/7 y documentación en español.

**¡Tu landing page está lista para vender!** 🚀💚
