# Landing Page: Cómo Emprender Desde Casa Siendo Mamá

## Descripción
Landing page profesional y responsiva para el ebook "Cómo Emprender Desde Casa Siendo Mamá", diseñada con HTML, CSS, JavaScript y Bootstrap 5.

## Características

### Diseño
- **Responsiva**: Se adapta perfectamente a móviles, tablets y escritorio
- **Paleta de colores**: Tonos cálidos (beige, crema, verde salvia, terracota) que transmiten calma y confianza
- **Tipografía**: 
  - Títulos: Playfair Display (elegante y profesional)
  - Texto: Inter (moderna y legible)

### Secciones
1. **Hero Section**: Título principal, subtítulo, bullets de impacto y CTA
2. **Empatía**: Identificación con los dolores y necesidades del público objetivo
3. **Solución**: Presentación del producto y su propuesta de valor
4. **Beneficios**: Qué logrará la usuaria en 30 días
5. **Qué Incluye**: Contenido del ebook y bonus
6. **Para Quién Es**: Segmentación clara del público objetivo
7. **Orderbump**: Oferta complementaria
8. **CTA Final**: Llamado a la acción con beneficios destacados
9. **FAQ**: Preguntas frecuentes con acordeón interactivo
10. **Cierre Emocional**: Mensaje final motivador

### Funcionalidades
- Smooth scroll para navegación fluida
- Animaciones de entrada al hacer scroll
- Acordeón interactivo en FAQ
- Botones CTA con efectos hover
- Optimización para SEO
- Accesibilidad mejorada

## Estructura de Archivos
```
landing-mama-emprendedora/
├── index.html          # Estructura HTML principal
├── styles.css          # Estilos personalizados
├── script.js           # Funcionalidades JavaScript
├── hero-image.jpg      # Imagen principal del hero
├── problema-image.jpg  # Imagen de la sección de empatía
├── solucion-image.jpg  # Imagen de la sección de solución
├── bonus-image.jpg     # Imagen de la sección orderbump
├── confianza-image.jpg # Imagen de la sección de cierre
└── README.md           # Este archivo
```

## Cómo Usar

### Opción 1: Abrir directamente
1. Abre el archivo `index.html` en tu navegador web
2. La página se cargará con todos los estilos y funcionalidades

### Opción 2: Servidor local
```bash
# Con Python 3
python3 -m http.server 8000

# Con Node.js (si tienes http-server instalado)
npx http-server

# Luego abre en tu navegador:
# http://localhost:8000
```

## Personalización

### Cambiar colores
Edita las variables CSS en `styles.css`:
```css
:root {
    --color-bg-primary: #F7F4EF;
    --color-button: #B86B4B;
    /* ... más variables */
}
```

### Cambiar textos
Edita directamente el contenido en `index.html`

### Cambiar imágenes
Reemplaza los archivos `.jpg` manteniendo los mismos nombres, o actualiza las rutas en `index.html`

### Cambiar link de compra
Busca y reemplaza todas las instancias de:
```
https://pay.hotmart.com/Y104042994D?checkoutMode=10
```

## Optimizaciones Incluidas

- ✅ Diseño mobile-first
- ✅ Imágenes optimizadas
- ✅ Carga rápida de fuentes
- ✅ CSS y JS minificables
- ✅ Estructura semántica HTML5
- ✅ Meta tags para SEO
- ✅ Accesibilidad (ARIA labels)

## Tecnologías Utilizadas

- **HTML5**: Estructura semántica
- **CSS3**: Estilos personalizados con variables CSS
- **JavaScript ES6**: Funcionalidades interactivas
- **Bootstrap 5.3.2**: Framework CSS responsivo
- **Google Fonts**: Playfair Display e Inter

## Compatibilidad

- ✅ Chrome (últimas 2 versiones)
- ✅ Firefox (últimas 2 versiones)
- ✅ Safari (últimas 2 versiones)
- ✅ Edge (últimas 2 versiones)
- ✅ Dispositivos móviles (iOS y Android)

## Próximos Pasos Recomendados

1. **Hosting**: Subir a un servicio como Netlify, Vercel o GitHub Pages
2. **Dominio**: Conectar un dominio personalizado
3. **Analytics**: Agregar Google Analytics o similar
4. **Pixel de conversión**: Instalar pixel de Facebook/Instagram si usas ads
5. **Testing**: Probar en diferentes dispositivos y navegadores
6. **SEO**: Optimizar meta tags, agregar Open Graph para redes sociales

## Soporte

Para modificaciones o dudas sobre la landing page, consulta la documentación de:
- [Bootstrap 5](https://getbootstrap.com/docs/5.3/)
- [MDN Web Docs](https://developer.mozilla.org/)

---

**Desarrollado con ❤️ para mamás emprendedoras**
