// ========================================
// Smooth Scroll para enlaces internos
// ========================================
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function (e) {
        e.preventDefault();
        const target = document.querySelector(this.getAttribute('href'));
        if (target) {
            target.scrollIntoView({
                behavior: 'smooth',
                block: 'start'
            });
        }
    });
});

// ========================================
// Animación de entrada al hacer scroll
// ========================================
const observerOptions = {
    threshold: 0.1,
    rootMargin: '0px 0px -50px 0px'
};

const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
        if (entry.isIntersecting) {
            entry.target.classList.add('fade-in-up');
            observer.unobserve(entry.target);
        }
    });
}, observerOptions);

// Observar secciones para animación
document.addEventListener('DOMContentLoaded', () => {
    const sections = document.querySelectorAll('section');
    sections.forEach(section => {
        observer.observe(section);
    });
});

// ========================================
// Tracking de clics en botones CTA
// ========================================
const ctaButtons = document.querySelectorAll('.btn-cta');
ctaButtons.forEach(button => {
    button.addEventListener('click', function() {
        // Aquí puedes agregar código de tracking/analytics
        console.log('CTA clicked:', this.textContent);
        
        // Ejemplo: Google Analytics
        // gtag('event', 'cta_click', {
        //     'event_category': 'engagement',
        //     'event_label': this.textContent
        // });
    });
});

// ========================================
// Efecto hover mejorado en cards
// ========================================
const cards = document.querySelectorAll('.include-card, .for-who-card, .orderbump-card');
cards.forEach(card => {
    card.addEventListener('mouseenter', function() {
        this.style.transition = 'all 0.3s ease';
    });
});

// ========================================
// Validación y mejora de accesibilidad
// ========================================
document.addEventListener('DOMContentLoaded', () => {
    // Agregar atributos ARIA a acordeones
    const accordionButtons = document.querySelectorAll('.accordion-button');
    accordionButtons.forEach(button => {
        button.setAttribute('role', 'button');
    });
    
    // Mejorar accesibilidad de imágenes
    const images = document.querySelectorAll('img');
    images.forEach(img => {
        if (!img.hasAttribute('alt') || img.getAttribute('alt') === '') {
            console.warn('Imagen sin texto alternativo:', img.src);
        }
    });
});

// ========================================
// Preloader para imágenes (opcional)
// ========================================
window.addEventListener('load', () => {
    document.body.classList.add('loaded');
    console.log('Página completamente cargada');
});

// ========================================
// Detección de scroll para efectos adicionales
// ========================================
let lastScroll = 0;
window.addEventListener('scroll', () => {
    const currentScroll = window.pageYOffset;
    
    // Aquí puedes agregar efectos adicionales basados en scroll
    // Por ejemplo, mostrar/ocultar un botón de "volver arriba"
    
    lastScroll = currentScroll;
});

// ========================================
// Función para copiar texto (útil para códigos de descuento)
// ========================================
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(() => {
        console.log('Texto copiado:', text);
        // Aquí puedes mostrar un mensaje de confirmación
    }).catch(err => {
        console.error('Error al copiar:', err);
    });
}

// ========================================
// Prevenir envío de formularios vacíos (si se agregan)
// ========================================
const forms = document.querySelectorAll('form');
forms.forEach(form => {
    form.addEventListener('submit', function(e) {
        const inputs = this.querySelectorAll('input[required], textarea[required]');
        let isValid = true;
        
        inputs.forEach(input => {
            if (!input.value.trim()) {
                isValid = false;
                input.classList.add('is-invalid');
            } else {
                input.classList.remove('is-invalid');
            }
        });
        
        if (!isValid) {
            e.preventDefault();
            console.log('Formulario incompleto');
        }
    });
});

// ========================================
// Lazy loading para imágenes (mejora de rendimiento)
// ========================================
if ('loading' in HTMLImageElement.prototype) {
    const images = document.querySelectorAll('img[loading="lazy"]');
    images.forEach(img => {
        img.src = img.dataset.src;
    });
} else {
    // Fallback para navegadores que no soportan lazy loading nativo
    const script = document.createElement('script');
    script.src = 'https://cdnjs.cloudflare.com/ajax/libs/lazysizes/5.3.2/lazysizes.min.js';
    document.body.appendChild(script);
}

// ========================================
// Console log de bienvenida
// ========================================
console.log('%c¡Bienvenida! 🌟', 'font-size: 20px; color: #B86B4B; font-weight: bold;');
console.log('%cCómo Emprender Desde Casa Siendo Mamá', 'font-size: 14px; color: #9FB7A0;');
console.log('Landing page desarrollada con ❤️');
